
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Thu Jan 13 16:26:50 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_UTIL_Funcs.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2006 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/* canceling the lint warning: */
/*lint --e{718} */
/*lint --e{746} */
/*lint --e{826} */


/************* Include Files ****************/
#include "MW_ATP_UTIL_funcs.h"
#include "MNG_ATP_TST_Defines.h"
#include "MNG_TST_Utils.h"
#include "DX_VOS_Stdio.h"
#include "DX_VOS_File.h"

#define DX_TST_DEBUG_OTP

#ifdef DX_TST_DEBUG_OTP
  #include "gen.h"
  #include "GeneralHwDefs.h"
  #include "cc_start_addr.h" 
  #include "Init_CC.h"
  //#include "CRYS_INIT_TST.h"
#endif

/************************ Defines ************************/
/************************ Enums **************************/
/************************ Typedefs ***********************/
/************************ Global Data ********************/
#if MNG_TST_LOG_ENABLE 
extern DxVosFile  TST_MNG_main_log;
#endif

#ifdef DX_CC5_SEP_PLAT
extern DxError_t MNG_ATP_TST_CC_LoadCode(DxUint32_t TST_resAdd, DxUint32_t TST_cacheAddr);
#endif
/************* Private function prototype ****************/
/************************ Public Functions ***************/
/*****************************************************************************
 * Function Name:
 *  MNG_TST_CheckErrorReturn
 *
 * Inputs:
 *  DxUint32_t  TST_ErrorRet - The return value of the checked function
 *  char TST_FuncName[TST_FUNC_STRING_LEN] - The checked function name
 *  char     TST_SubTestName[TST_FUNC_STRING_LEN] - The checked sub test name
 *  char     TST_MasterTestName[TST_FUNC_STRING_LEN]- The checked main test name
 *
 * Outputs:
 *  DxUint8_t - Function error return
 *
 * Description:
 * This function Is a utility function to save up some space
 * this function returns the appropriate printing for a checked function
 * If the operation has succeeded of failed the appropriate printing and return value
 *
 ******************************************************************************/
DxError_t MNG_TST_CheckErrorReturn(DxError_t  TST_ErrorRet,
                                   char       TST_FuncName[TST_FUNC_STRING_LEN],
                                   char       TST_SubTestName[TST_FUNC_STRING_LEN],
                                   char       TST_MasterTestName[TST_FUNC_STRING_LEN])
{
    if (TST_ErrorRet != DX_SUCCESS)
        {
            MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"\n!!!! TST_Error - Master Test Name -%s\n",TST_MasterTestName));
            MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"!!!! TST_Error - SubTest Name -%s\n",TST_SubTestName));
            MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"!!!! TST_Error - %s failed\n",TST_FuncName));
            MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"!!!! TST_Error - MNG_API returned %1x \n",TST_ErrorRet));
            return TST_ErrorRet;
        }
    else
        {
            MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"TST_message - "));
            MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"%s",TST_FuncName));
            MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG," pass \n"));
            return DX_SUCCESS;
        }
}

/*****************************************************************************
 * Function Name:
 *  MNG_TST_CheckErrorReturn_Expected
 *
 * Inputs:
 *  DxUint32_t  TST_ErrorRet - The return value of the checked function
 *  DxUint32_t  TST_ExpectedRet - The expected return value 
 *  char TST_FuncName[TST_FUNC_STRING_LEN] - The checked function name
 *  char     TST_SubTestName[TST_FUNC_STRING_LEN] - The checked sub test name
 *  char     TST_MasterTestName[TST_FUNC_STRING_LEN]- The checked main test name
 *
 * Outputs:
 *  DxUint8_t - Function error return
 *
 * Description:
 * This function Is a utility function to save up some space
 * this function returns the appropriate printing for a checked function
 * If the operation has succeeded as expected of failed the appropriate printing 
 * and return value
 *
 ******************************************************************************/
DxError_t MNG_TST_CheckErrorReturn_Expected(DxError_t  TST_ErrorRet,
											DxError_t  TST_ExpectedRet,
                                            char       TST_FuncName[TST_FUNC_STRING_LEN],
  		                                    char       TST_SubTestName[TST_FUNC_STRING_LEN],
		                                    char       TST_MasterTestName[TST_FUNC_STRING_LEN])
{   
	if (TST_ErrorRet != TST_ExpectedRet)
        {
            MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"\n!!!! TST_Error - Master Test Name -%s\n",TST_MasterTestName));
            MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"!!!! TST_Error - SubTest Name -%s\n",TST_SubTestName));
            MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"!!!! TST_Error - %s failed\n",TST_FuncName));
            MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"!!!! TST_Error - MNG_API returned %1x \n",TST_ErrorRet));
            MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"!!!! TST_Error - Extected error return is - %1x \n",TST_ExpectedRet));
            return TST_ErrorRet;
        }
    else
        {
            MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"TST_message - "));
            MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"%s",TST_FuncName));
            MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG," returned the expected error return \n"));
            return DX_SUCCESS;
        }	
    
}

/*****************************************************************************
 * Function Name:
 *  MNG_LOG_TST
 *
 * Inputs:
 *  DxUint8_t level - the printing level if it is below the ATP_LOG_TST_MAX_LEVEL_ENABLED
 *                    flag setting it will not be printed.
 *  const char format,... - the printf format.
 *
 * Outputs:
 *   None
 *
 * Description:
 * The following function handles the printings logging of the testing suite .
 *        This function should be called by using the KMNG_LOG_TST_PRINT macro
 *
 ******************************************************************************/

#if ATP_LOG_TST_MAX_LEVEL_ENABLED

int MNG_LOG_TST( DxUint8_t level , const char *format,... )
{
  /* LOCAL DECLERATIONS */
  /**********************/
  DX_VA_LIST ap;
  DX_VA_START(ap, format);

  DX_VOS_UpdateStdout();
  
  /* FUNCTION LOGIC */
  /*****************/  
  #if MNG_TST_LOG_ENABLE
  if( level < ATP_LOG_TST_MAX_LEVEL_ENABLED )
  {
    if (TST_MNG_main_log != DX_NULL)
    {
       DX_VOS_VFPrintf(TST_MNG_main_log,format, ap );
    }
  }
  #endif
      
  /* if the printing level is enabled then print it to STDIO*/
  if( level < ATP_LOG_TST_MAX_LEVEL_ENABLED )
  {
    DX_VOS_VPrintf(format , ap);    
  }
  
  DX_VA_END(ap);  
  
  return DX_SUCCESS;

}/* END OF MNG_LOG_TST */


/*****************************************************************************
 * Function Name:
 *  MNG_LOG_TST
 *
 * Inputs:
 *  DxUint32_t *TST_CounterBuffPtr - The buffer containing the counter.
 *  DxUint32_t TST_Val - The value to add
 *  DxUint8_t  TST_ConterSize - the counter size in 32bit words
 *
 * Outputs:
 *   None
 *
 * Description:
 * 		This function adds a value to a large counter presented in a buffer.
 *      The LSB of the counter is stored in the first cell in the array.
 *
 ******************************************************************************/
                              
 void MNG_TST_IncLsbUnsignedCounter(DxUint32_t *TST_CounterBuffPtr,
                                    DxUint32_t TST_Val,
                                    DxUint8_t  TST_CounterSize )
 {
	/* LOCAL DECLERATIONS */
  	/**********************/
 	/* a value for storing the current counter word value */
	DxUint32_t curretCounterWordVal = 0;    
    DxInt32_t i = 0;
   
   	/* FUNCTION LOGIC */
   	/*****************/
   	curretCounterWordVal = TST_CounterBuffPtr[0];
   
   	/* adding the value to the LSW */   
   	TST_CounterBuffPtr[0] += TST_Val;
        
   	/* adding the carry to the higher words if there is overflow on the word 
       then handle the upper words */
   	if( curretCounterWordVal > TST_CounterBuffPtr[0] )
   	{  
     	/* adding the carry to the counter loop */
     	for( i = 1 ; i < TST_CounterSize ; i++ )
     	{
        	/* set the current word value */
        	curretCounterWordVal = TST_CounterBuffPtr[i];
      
        	/* adding the carry to the current word */
        	TST_CounterBuffPtr[i]++;
            
        	/* if there is no overflow on the current word after adding the value 
           	   exit the loop */
        	if( curretCounterWordVal < TST_CounterBuffPtr[i] )       
          		break;        
     	}/* end of adding the carry loop */     
   	}/* end of setting the carrier on the upper words */  
   	return;
 }
 
 /*****************************************************************************
 * Function Name:
 *  MNG_TST_Reset_SEP
 *
 * Inputs:
 * 	N/A
 *
 * Outputs:
 *   None
 *
 * Description:
 * 		This function performs a SW reset to the SEP
 *
 ******************************************************************************/
 DxError_t MNG_TST_Reset_SEP(void)
 {
  DxError_t TST_TestStatus = DX_SUCCESS;
  
  /* Clear warm boot indication to apply cold boot */
  TST_TestStatus = DX_MNG_ClearWarmBootIndication();
  if(TST_TestStatus != DX_SUCCESS)
  {
    return MNG_TEST_FAIL;
  }
  /* Reset the SEP and initialize it, only relevant in debug mode */
  #ifdef DX_TST_DEBUG_OTP
      /* reset the SEP*/
      DX_GEN_WriteRegister(MNG_TST_HW_SEP_SW_RST_REG_ADDR,0x1);
      
      TST_TestStatus = MW_ATP_UTIL_Init_SEP();
      if(TST_TestStatus != DX_SUCCESS)
      {
        return MNG_TEST_FAIL;
      }
	    
  #endif
 	return MNG_TEST_PASS;
 }
 
 /*****************************************************************************
 * Function Name:
 *  MNG_TST_Reset_SEP_No_ClearIndication
 *
 * Inputs:
 * 	N/A
 *
 * Outputs:
 *   None
 *
 * Description:
 * 		This function performs a SW reset to the SEP
 *
 ******************************************************************************/
 DxError_t MNG_TST_Reset_SEP_No_ClearIndication(void)
 {
  DxError_t TST_TestStatus = DX_SUCCESS;
    
  /* Reset the SEP and initialize it, only relevant in debug mode */
  #ifdef DX_TST_DEBUG_OTP
      /* reset the SEP*/
      DX_GEN_WriteRegister(MNG_TST_HW_SEP_SW_RST_REG_ADDR,0x1);
      
      TST_TestStatus = MW_ATP_UTIL_Init_SEP();
      if(TST_TestStatus != DX_SUCCESS)
      {
        return MNG_TEST_FAIL;
      }
	    
  #endif
 	return MNG_TEST_PASS;
 }
 
 /*****************************************************************************
 * Function Name:
 *  MNG_TST_Reset_SEP_WarmBoot
 *
 * Inputs:
 * 	N/A
 *
 * Outputs:
 *   None
 *
 * Description:
 * 		This function performs a SW reset to the SEP
 *
 ******************************************************************************/
 DxError_t MNG_TST_Reset_SEP_WarmBoot(void)
 {
  DxError_t TST_TestStatus = DX_SUCCESS;
  
  /* Reset the SEP and initialize it, only relevant in debug mode */
  #ifdef DX_TST_DEBUG_OTP
      /* reset the SEP */
      DX_GEN_WriteRegister(MNG_TST_HW_SEP_SW_RST_REG_ADDR,0x1);
      TST_TestStatus = DX_CC_Start();
      if(TST_TestStatus != DX_SUCCESS)      
      	return TST_FAIL;
	    
  #endif
 	return MNG_TEST_PASS;
 }
 
 /*****************************************************************************
 * Function Name:
 *  MNG_TST_Snapshot_SEP 
 *
 * Inputs:
 * 	N/A
 *
 * Outputs:
 *   None
 *
 * Description:
 * 		This function performs snapshot
 *
 ******************************************************************************/
 void MNG_TST_Snapshot_SEP(void)
 {  
  /* Do snapshot */
  #ifdef DX_TST_DEBUG_OTP
      /* snapshot */
	  DX_GEN_WriteRegister(MNG_TST_HW_SNAPSHOT_REG_1, 0x1); 
  #endif
 	return;
 }
 
/*****************************************************************************
 * Function Name:
 *  MNG_ATP_Print_Version
 *
 * Inputs:
 * 	SEP_Version_t TST_Version - component version
 *
 * Outputs:
 *   None
 *
 * Description:
 * 		This function prints a given version
 *
 ******************************************************************************/ 
void MNG_ATP_Print_Version(SEP_Version_t TST_Version, MwVersionInfo_t TST_MW_Version)
{
	DxUint32_t TST_index = 0;
	
	/*Printing the given version */
    /*-------------------------------*/
    if (TST_MW_Version == DX_NULL)
    {    	  	    	    	                       		
	                       
	    MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"\n--------------[%s VERSION - %c%d,%d,%d,%d]-------------\n\n",
	                                        TST_Version.compName,
	                                        TST_Version.type,
	                                        TST_Version.major,
	                                        TST_Version.minor,
	                                        TST_Version.sub,
	                                        TST_Version.internal));		
    }
    else
    {    	
    	
    	MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"\n--------------[ VERSION  - "));
    	for (TST_index = 0; TST_index < sizeof(MwVersionInfo_t); TST_index ++)
    	{
    		if (TST_MW_Version[TST_index] != 'Z')
    			MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"%c",TST_MW_Version[TST_index]));	
    		else
    			break;
    	}
    	MNG_LOG_TST_PRINT((MNG_ATP_TST_MSG,"]-------------\n\n"));    	
    }
}


#endif


